<?php
// contact.php
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Contact Us - Art Exhibition</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: Arial, sans-serif;
      background: #C09ADB;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
    }

    .container {
      background: #F5F5F5;
      padding: 20px;
      width: 350px;
      border-radius: 10px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.1);
    }

    h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #333;
    }

    label {
      display: block;
      margin-bottom: 5px;
      font-weight: bold;
    }

    input[type="text"],
    input[type="email"],
    textarea {
      width: 100%;
      padding: 10px;
      margin-bottom: 15px;
      border: 1px solid #ccc;
      border-radius: 5px;
      font-size: 14px;
      box-sizing: border-box;
    }

    textarea {
      resize: none;
      height: 100px;
    }

    button {
      width: 100%;
      padding: 10px;
      background: #623C74;
      color: white;
      border: none;
      border-radius: 5px;
      font-size: 16px;
      cursor: pointer;
      transition: background 0.3s;
    }

    button:hover {
      background: #623C74;
    }

    .back-link {
      text-align: center;
      margin-top: 15px;
    }

    .back-link a {
      text-decoration: none;
      color: #623C74;
      font-weight: bold;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>Contact Us</h2>
    <form action="send_message.php" method="POST">
      <label for="name">Full Name</label>
      <input type="text" id="name" name="name" placeholder="Your Name" required>

      <label for="email">Email</label>
      <input type="email" id="email" name="email" placeholder="Your Email" required>

      <label for="message">Message</label>
      <textarea id="message" name="message" placeholder="Write your message..." required></textarea>

      <button type="submit">Send Message</button>
    </form>
    <div class="back-link">
      <a href="index.php">⬅ Back to Home</a>
    </div>
  </div>
</body>
</html>
